% =========================================================================
%   Praktikum MATLAB/Simulink II
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

function [A, B, C, D] = initLinear( l, mp, ms, Rs, Rp, g, AP )
% function [A, B, C, D] = initLinear( lPendel, mPendel, mSchlitten, ...
%							RSchlitten, RPendel, g, arbeitspunkt)
% Arbeitspunkt:
% arbeitspunkt = 0; oder
% arbeitspunkt = pi;
%
% Zustnde:
% x = [ xs, xs_d, phi, phi_d ]'
%

	if ( AP == 0 )
		% Hngendes Pendel
		A = [
			[0,     1,            0,                   0];
			[0, -4*Rs,       3*g*mp,              6*Rp/l] / (4*ms+mp);
			[0,     0,            0,                   1];
			[0,  6*Rs, -6*g*(ms+mp), -12*Rp*(ms+mp)/l/mp] / (l*(4*ms+mp));
			];

		B = [0; 4; 0; -6/l]/(4*ms+mp);

		C = [1, 0, 0, 0;
			 0, 0, 1, 0];
		  
	elseif ( AP == pi )
		% Stehendes Pendel
		A = [
			[0,     1,           0,                   0];
			[0, -4*Rs,      3*g*mp,             -6*Rp/l] / (4*ms+mp);
			[0,     0,           0,                   1];
			[0, -6*Rs, 6*g*(ms+mp), -12*Rp*(ms+mp)/l/mp] / (l*(4*ms+mp));
			];

		B = [0; 4; 0; 6/l]/(4*ms+mp);

		C = [1, 0, 0, 0;
		     0, 0, 1, 0];

	else
		% Andere Werte fr AP entweder nicht sinnvoll, da kein
		% AP oder schlicht Vielfache von pi und daher nicht relevant.
		error( ['Wert arbeitspunkt = ', AP, ' nicht untersttzt.'] );
	end	  
	
	D = [0; 0];
	
end
